(*| 10:33 21/05/1990 *)
PROGRAM NOTPU;

USES Crt,Dos;

CONST
  MaxDir=12000;

TYPE
  FNameType= STRING[12];
  LineString= STRING[80];

VAR
  FindRec: SearchRec;
  FileSpec,OptionString,TextLine: LineString;
  ListFileName: LineString;
  I,NumOfPasFiles,NumOfTpuFiles,NumOfExeFiles: Integer;
  Abort,SaveToFile,DoErase: Boolean;
  C:Char;
  ListFile:TEXT;
  DirData: ARRAY[1..MaxDir] OF ^LineString;
  MemMark: Pointer;
  ThisFileText:LineString;

{ ==================== GENERAL PURPOSE STRING ROUTINES ====================== }
FUNCTION FixString(FString : LineString; Len : Byte) : LineString;
{ Makes a string a specified length.  If the string is too long, the extra
  characters will be truncated.  If the string is too short, the string will
  be padded with spaces.
}
var StringLen : byte absolute FString;
                            { Make a variable for FString's length byte }
BEGIN
  IF StringLen > Len THEN
    Delete(FString, Succ(Len), StringLen - Len)
                                    { Delete end of string if it is too long }
  ELSE
    WHILE StringLen < Len DO          { Pad FString with spaces on the right }
      FString := FString + ' ';
  FixString := FString;
END; { FixString }

FUNCTION UpperCase(S : LineString) : LineString;
{ Convert a string to all upper case letters }
VAR I : integer;
BEGIN                               { Note that we intentionally modify a    }
  FOR I := 1 to LENGTH(S) DO        { VALUE parameter, and then return that  }
    S[I] := UpCase(S[I]);           { modified value via the function value. }
  UpperCase := S;
END; { UpperCase }

PROCEDURE ShowHelp;
BEGIN
  Writeln('Usage    : ');
  Writeln(
    '  NOTPU [D:][DestFileName] [/P][/D]');
  Writeln;
  Writeln('Switches : /P    Copy output to printer');
  Writeln('           /E    Erase redundant PAS files');
  Writeln('           /D    Copy output to disk, default filename CATDIR.TXT');
  Writeln;
  Writeln('Free memory ',MaxAvail);
  HALT;
END;  { ShowHelp }

FUNCTION ResultOK:Boolean;
VAR
  I:Integer;
BEGIN
  I:=IOResult;
  IF I = 0 THEN
    ResultOK:=True
  ELSE BEGIN
    ResultOK:=False;
    Writeln;
    Writeln('IOError #',I);
  END;
END;

PROCEDURE ProcessOptions;
BEGIN
  DoErase:=False;
  IF POS('/D',OptionString) > 0 THEN SaveToFile:=True;
  IF POS('/E',OptionString) > 0 THEN DoErase:=True;
END; { ProcessOptions }

FUNCTION AbortTest: Boolean;
VAR
  C:Char;
BEGIN
  IF KeyPressed THEN BEGIN
    C:=ReadKey;
    Writeln('Abort Y/N ? ');
    C:=ReadKey;
    IF UpCase(C) = 'Y' THEN Abort:=True;
    Writeln('Aborting');
  END;
  AbortTest:=Abort;
END; { AbortTest }

PROCEDURE DoFileSave;
VAR
  NumOnLine: Integer;
BEGIN
  Assign(ListFile,ListFileName);
  Rewrite(ListFile);
  Writeln('Saving Data To ',ListFileName);
  NumOnLine:=0;
  FOR I:=1 TO NumOfPasFiles DO
    Writeln(ListFile,DirData[I]^);
  Close(ListFile);
END;  { DoFileSave }

PROCEDURE ProcessThisFileText;
VAR
  P:Integer;
  FileBody:String[9];
  PasFile: TEXT;
  FindExtRec: SearchRec;
BEGIN
{  Write(NumOfPasFiles:5,'  ',ThisFileText);}
  P:=POS('.',ThisFileText);
  IF P = 0 THEN
    Writeln('No .EXT in file ',ThisFileText)
  ELSE BEGIN
    FileBody:=COPY(ThisFileText,1,P);
{    Write(' ',FileBody);}
    FindFirst(FileBody+'TPU',Archive,FindExtRec);
    IF DosError=0 THEN BEGIN
      INC(NumOfTpuFiles);
{      Writeln(' .TPU ok');}
    END ELSE BEGIN
      FindFirst(FileBody+'EXE',Archive,FindExtRec);
      IF DosError=0 THEN BEGIN
        INC(NumOfExeFiles);
{        Writeln(' .EXE ok');}
       END ELSE IF NOT DoErase THEN BEGIN
         Write(NumOfPasFiles:5,'  ',ThisFileText);
{         Writeln(' none found');}
       END ELSE BEGIN
         Writeln;
         Write('Erase ',ThisFileText,' Y/N ?');
         IF UpCase(ReadKey) = 'Y' THEN BEGIN
           ASSIGN(PasFile,ThisFileText);
           ERASE(PasFile);
         END;
         Writeln;
       END;
    END;
  END;
  IF SaveToFile THEN BEGIN
    IF NumOfPasFiles > MaxDir THEN
      BEGIN
        Writeln('Too many files');
        Abort:=True;
      END
    ELSE IF MaxAvail < 162 THEN
      BEGIN
        Writeln('Insufficient memory');
        Abort:=True;
      END
    ELSE BEGIN
      GetMem(DirData[NumOfPasFiles],Length(ThisFileText) + 1);
      DirData[NumOfPasFiles]^:=ThisFileText;
    END;
  END;
END;  { ProcessThisFileText }

PROCEDURE ProcessThisFile(FileInfo:SearchRec);

BEGIN
  WITH FileInfo DO BEGIN
    INC(NumOfPasFiles);
    ThisFileText:=FixString(Name,12) + ' ';
    ProcessThisFileText;
  END;
END; { ProcessThisFile }

PROCEDURE ShowFiles;
BEGIN
  FindFirst(FileSpec,Archive,FindRec);
  WHILE DosError=0 DO BEGIN
    ProcessThisFile(FindRec);
    FindNext(FindRec);
{    IF AbortTest THEN Exit;}
  END;
(*  Writeln;*)
END; { ShowFiles }

BEGIN
  Writeln('No .TPU Program by B Whitnall, V1.0');
  OptionString:='';
  FileSpec:='*.PAS';
  SaveToFile:=False;
  ListFileName:='NOTPU.TXT';
  IF ParamCount > 0 THEN FOR I:=1 TO ParamCount DO BEGIN
    TextLine:=UpperCase(ParamStr(I));
    IF TextLine[1] = '/' THEN
      OptionString:=OptionString + TextLine
    ELSE BEGIN
      IF I = 1 THEN BEGIN
        ListFileName:=TextLine;
        SaveToFile:=True;
      END;
    END;
  END;
  IF ListFileName = '?' THEN ShowHelp;
  ProcessOptions;
  NumOfPasFiles:=0;
  NumOfTpuFiles:=0;
  NumOfExeFiles:=0;
  Abort:=False;
  Mark(MemMark);
  ShowFiles;
  Writeln;
  Write(NumOfPasFiles:5,' PAS files');
  Write(NumOfTpuFiles:5,' TPU files');
  Write(NumOfExeFiles:5,' EXE files');
  Writeln(NumOfPasFiles-NumOfTpuFiles-NumOfExeFiles:5,' extra PAS files');
  IF SaveToFile THEN DoFileSave;
  Release(MemMark);
END.
